import { UserBaseSchema } from 'entities/User/types/UserBaseSchema';

export interface CurrentUserSchema {
    passport: {
        avatar_url: string;
        display_name: string;
    };
    plus: {
        is_activated: boolean;
    };
    is_registration_started: boolean;
    is_first_riding: boolean;
    is_registred: boolean;
    details: UserDetails;
    user_id: string;
    driving_style: DrivingStyle;
    settings: string[];
    validated_emails: string[];
}

interface UserDetails extends UserBaseSchema {
    setup: Record<string, any>;
    preliminary_payments: {
        enabled: boolean;
        amount: number;
    };
    username: string;
}

interface DrivingStyle {
    notifications: any[];
    next_color: string;
    last_change: Record<string, string>;
    title: string;
    descriptions: Record<'description' | 'title', string>[];
    prev_color: string;
    sessions: Record<string, string>;
    button: Record<string, string>;
    photo: Record<string, string>;
    prev_title: string;
    next_title: string;
}
