export type UserPhotoContentTypeSchema = 'lb' | 'lf' | 'pb' | 'ps';

export interface UserPhotoContentSchema {
    uri: string;
    origin_chat: string;
    background_video_uri: string;
    type: UserPhotoContentTypeSchema;
    id: string;
    submitted_at: number;
    verified_at: Nullable<number>;
    verification_status: Nullable<string>;
}

export interface UserPhotosSchema {
    passport: {
        registration: UserPhotoContentSchema[];
        biographical: UserPhotoContentSchema[];
        selfie: UserPhotoContentSchema[];
    };
    driving_license: {
        back: UserPhotoContentSchema[];
        front: UserPhotoContentSchema[];
        selfie: UserPhotoContentSchema[];
    };
}
