import { UserBaseSchema } from 'entities/User/types/UserBaseSchema';
import { UserDrivingLicenseSchema } from 'entities/User/types/UserDrivingLicenseSchema';
import { UserPassportSchema } from 'entities/User/types/UserPassportSchema';
import { UserPhotosSchema } from 'entities/User/types/UserPhotosSchema';
import { UserSetupSchema } from 'entities/User/types/UserSetupSchema';

export interface UserSchema extends UserBaseSchema {
    address: string;
    photos: UserPhotosSchema;
    documents: {
        passport: Array<UserPassportSchema & { revision: string }>;
        driving_license: Array<UserDrivingLicenseSchema & { revision: string }>;
    };
    passport_revision: string;
    driving_license_revision: string;
    setup: UserSetupSchema;
    preliminary_payments?: {
        enabled: boolean;
        amount: number;
    };
}
