import * as React from 'react';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button, ButtonProps } from 'shared/ui/Button/Button';

import { i18n } from 'entities/User/ui/UserAddButton/UserAddButton.i18n';

import PlusIcon from 'shared/ui/Icons/images/plus-outline-16.inline.svg';

export interface UserAddButtonProps extends Pick<ButtonProps, 'onClick'> {
    className?: string;
}

export const UserAddButton: React.FC<UserAddButtonProps> = function UserAddButton({ className, onClick }) {
    const onClickHandler = React.useCallback(
        (event: React.MouseEvent<HTMLAnchorElement | HTMLButtonElement>) => {
            onClick?.(event);
        },
        [onClick],
    );

    return (
        <Button
            className={className}
            color={ButtonColor.PRIMARY}
            size={ButtonSize.M}
            icon={PlusIcon}
            label={i18n('Add user')}
            onClick={onClickHandler}
        />
    );
};
