import * as React from 'react';
import cn from 'classnames';

import { showUserScoringInformer } from 'utils/showUserScoringInformer';

import { UseUserMemberResource } from 'entities/User/api/useUserMember/useUserMember';
import { getUserFullName } from 'entities/User/helpers/getUserFullName/getUserFullName';
import { UserStatusInfo } from 'entities/User/ui/UserStatusInfo/UserStatusInfo';

import { DotText } from 'shared/ui/DotText/DotText';
import { Scoring } from 'shared/ui/Scoring/Scoring';

import styles from 'entities/User/ui/UserHeaderTitle/UserHeaderTitle.css';

export interface UserHeaderTitleProps {
    className?: string;
    resource: UseUserMemberResource;
}

// @todo: add storybook test
export const UserHeaderTitle: React.FC<UserHeaderTitleProps> = function UserHeaderTitle({ className, resource }) {
    const user = resource.read();

    const { first_name: firstName, last_name: lastName, status, user_score: score } = user;

    const userScore = score?.rank;

    const scoreContent = showUserScoringInformer() && <Scoring value={userScore} />;
    const statusContent = (
        <UserStatusInfo
            className={styles.status}
            status={status}
            withoutIcon
        />
    );

    return (
        <div className={cn(styles.userHeaderTitle, [className])}>
            <h2 className={styles.name}>{getUserFullName(firstName, lastName)}</h2>

            <DotText
                className={styles.details}
                items={[scoreContent, statusContent]}
            />
        </div>
    );
};
