import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'E-mail': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'E-mail',
        ru: 'E-mail',
        cs: 'E-mail',
    },
    Name: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Name',
        ru: 'Имя',
        cs: 'Jméno',
    },
    'Open user profile in new window': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Open user profile in new window',
        ru: 'Открыть профиль пользователя в новом окне',
        cs: 'Otevřít uživatelský profil v novém okně',
    },
    'Phone number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Phone number',
        ru: 'Номер телефона',
        cs: 'Telefonní číslo',
    },
    Surname: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Surname',
        ru: 'Фамилия',
        cs: 'Příjmení',
    },
    'Switch into other customer': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Switch into other customer',
        ru: 'Сменить клиента',
        cs: 'Přepnout na jiného zákazníka',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
