import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { UserInput, UserInputProps } from 'entities/User/ui/UserInput/UserInput';

const storybookMeta = createStorybookMeta<UserInputProps>({
    title: 'entities/User/UserInput',
    component: UserInput,

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<UserInputProps>(UserInput);

export const normal = Template.bind({});
normal.args = {};

normal.hermioneFn = async (browser, selector) => {
    const menuEl = '[role="menu"]';

    await browser.$('[type="text"]:nth-child(1)').setValue('с');
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('suggest1', [selector, menuEl]);

    await browser.$('[type="text"]:nth-child(1)').setValue('са');
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('suggest2', [selector, menuEl]);

    await browser.$('li[role="option"]:nth-child(1)').click();
    await browser.assertView('selected', selector);

    await browser.$('button > span').click();
    await browser.$(menuEl).waitForDisplayed();
    await browser.assertView('menu', [selector, menuEl]);

    await browser.$('li[role="option"]:nth-child(1)').click();
    await browser.assertView('clear', selector);
};
