import * as React from 'react';

import { Header } from 'widgets/Header';

import { ContentContainer } from 'shared/ui/ContentContainer/ContentContainer';
import { SectionLayout } from 'shared/ui/SectionLayout/SectionLayout';

import { i18n } from 'entities/User/ui/UserNotFound/UserNotFound.i18n';

import styles from 'entities/User/ui/UserNotFound/UserNotFound.css';

export const UserNotFound: React.FC = function UserNotFound() {
    return (
        <SectionLayout
            header={
                <Header
                    title={i18n('Users')}
                    withoutBorder
                />
            }
            bodyScroll
        >
            <ContentContainer
                className={styles.content}
                bodyScroll
            >
                <h3 className={styles.title}>{i18n('User not found')}</h3>
            </ContentContainer>
        </SectionLayout>
    );
};
