import * as React from 'react';

import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { UserStatusForm, UserStatusFormProps } from 'entities/User/ui/UserStatusForm/UserStatusForm';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button } from 'shared/ui/Button/Button';

import ArrowIcon from 'shared/ui/Icons/images/arrow-short-forward-24.inline.svg';

const storybookMeta = createStorybookMeta<UserStatusFormProps>({
    title: 'entities/User/UserStatusForm',
    component: UserStatusForm,

    parameters: { backgrounds: { default: 'white' } },

    args: {
        storybookWidth: '500px',

        fullName: 'Aaron H. Bond',
        phoneNumber: '+420100000000',
        email: 'AaronHSuperLongBond@hotmail.com',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<UserStatusFormProps>(UserStatusForm);

export const normal = Template.bind({});

export const controls = Template.bind({});
controls.args = {
    controls: (
        <Button
            size={ButtonSize.M}
            color={ButtonColor.CLEAR}
            icon={ArrowIcon}
        />
    ),
};
