import * as React from 'react';
import cn from 'classnames/bind';

import { UserStatus } from 'entities/User/consts/UserStatus';
import { UserStatusInfo } from 'entities/User/ui/UserStatusInfo/UserStatusInfo';

import { formatPhoneNumber } from 'shared/helpers/formatPhoneNumber/formatPhoneNumber';
import { DotText } from 'shared/ui/DotText/DotText';

import styles from 'entities/User/ui/UserStatusForm/UserStatusForm.css';

export interface UserStatusFormProps {
    className?: string;
    fullName: string;
    status?: UserStatus;
    phoneNumber?: string;
    email?: string;
    controls?: React.ReactNode;
}

const cx = cn.bind(styles);

export const UserStatusForm: React.FC<UserStatusFormProps> = function UserStatusForm({
    className,
    fullName,
    status,
    phoneNumber,
    email,
    controls,
}) {
    const statusContent = (
        <UserStatusInfo
            className={styles.status}
            status={status}
        />
    );

    return (
        <div className={cx(styles.form, { controls }, [className])}>
            <div className={styles.content}>
                <h4 className={styles.fullName}>{fullName}</h4>

                <DotText
                    className={styles.details}
                    items={[statusContent, formatPhoneNumber(phoneNumber), email]}
                />
            </div>

            {controls}
        </div>
    );
};
