import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Active: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Active',
        ru: 'Активный',
        cs: 'Aktivní',
    },
    Blocked: {
        _meta: {
            context: 'User status',
            group: '1',
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Blocked',
        ru: 'Заблокирован',
        cs: 'Blokováno',
    },
    Deleted: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Deleted',
        ru: 'Удалён',
        cs: 'Odstraněno',
    },
    Onboarding: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Onboarding',
        ru: 'Активация',
        cs: 'Aktivace',
    },
    'Processing documents': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Processing documents',
        ru: 'Обработка документов',
        cs: 'Zpracování dokumentů',
    },
    Rejected: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Rejected',
        ru: 'Отклонён',
        cs: 'Odmítnuto',
    },
    'since {date}': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'since {date}',
        ru: 'с {date}',
        cs: 'od {date}',
    },
    'Waiting for activation': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Waiting for activation',
        ru: 'Ждёт активации',
        cs: 'Čeká se na aktivaci',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
