import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { UserStatus } from 'entities/User/consts/UserStatus';
import { UserStatusInfo, UserStatusInfoProps } from 'entities/User/ui/UserStatusInfo/UserStatusInfo';

const storybookMeta = createStorybookMeta<UserStatusInfoProps>({
    title: 'entities/User/UserStatusInfo',
    component: UserStatusInfo,
});

export default storybookMeta;

const Template = createStorybookTemplate<UserStatusInfoProps>(UserStatusInfo);

export const empty = Template.bind({});

export const unknown = Template.bind({});
unknown.args = { status: 'lol' as UserStatus };

export const active = Template.bind({});
active.args = { status: UserStatus.ACTIVE };

export const activeWithoutIcon = Template.bind({});
activeWithoutIcon.args = { status: UserStatus.ACTIVE, withoutIcon: true };

export const blocked = Template.bind({});
blocked.args = { status: UserStatus.BLOCKED };

export const blockedSince = Template.bind({});
blockedSince.args = { status: UserStatus.BLOCKED, date: new Date('2022-01-12') };

export const deleted = Template.bind({});
deleted.args = { status: UserStatus.DELETED };

export const external = Template.bind({});
external.args = { status: UserStatus.EXTERNAL };

export const onboarding = Template.bind({});
onboarding.args = { status: UserStatus.ONBOARDING };

export const rejected = Template.bind({});
rejected.args = { status: UserStatus.REJECTED };

export const screening = Template.bind({});
screening.args = { status: UserStatus.SCREENING };
