import { CarOfferSchema } from 'entities/Car/types/CarOfferSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';

interface PostCarOfferPayload {
    variables: Omit<CarOfferSchema, 'offer_id' | 'car_id' | 'primary' | 'secondary'>;
}

export type PostCarOfferData = Omit<CarOfferSchema, 'offer_id' | 'primary' | 'secondary'>;

export interface PostCarOfferRes {
    offers: [{ offer_id: string }];
}

export async function postCarOffer(data: PostCarOfferData): Promise<string> {
    const payload: PostCarOfferPayload = {
        variables: data,
    };

    const res = await fetchRequest<PostCarOfferPayload, PostCarOfferRes>('/api/yandex/offers/create', payload, {
        method: 'POST',
        query: {
            car_id: data.car_id,
            offer_builder_type: 'rental_offer_builder',
        },
    });

    return res.offers[0].offer_id;
}
