import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

type PostCarRentalData = OneOf<[PostCarRentalUserData, PostCarRentalNewUserData]>;

export interface PostCarRentalUserData {
    offer_id: string;
    client_id: string;
}

export interface PostCarRentalNewUserData {
    offer_id: string;
    first_name: string;
    last_name: string;
    phone_number: string;
    email?: string;
}

export function postCarRental(data: PostCarRentalData, cache?: CacheRequestContext) {
    return fetchRequest<PostCarRentalData, unknown>('/api/leasing/rental/book', data, {
        method: 'POST',
        cache,
    });
}
