import { CarOfferSchema } from 'entities/Car/types/CarOfferSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

interface UpdateCarOfferData extends CarOfferSchema {
    tag_id: Optional<string>;
}

export async function updateCarOffer(tagId: Optional<string>, data: CarOfferSchema, cache?: CacheRequestContext) {
    const payload: UpdateCarOfferData = {
        tag_id: tagId,
        ...data,
    };

    await fetchRequest<UpdateCarOfferData, unknown>('/api/leasing/rental/update', payload, {
        method: 'POST',
        cache,
    });
}
