import { CarOfferSchema } from 'entities/Car/types/CarOfferSchema';
import { useFetchRequest } from 'shared/hooks/useFetchRequest/useFetchRequest';
import { CarOfferConfigSchema } from 'entities/Car/types/CarOfferConfigSchema';
import { parseCarOfferConfig } from 'entities/Car/helpers/parseCarOfferConfig/parseCarOfferConfig';

export interface UseCarOfferConfigServerRes {
    offers: CarOfferSchema[];
}

export type UseCarOfferConfigRes = CarOfferConfigSchema;

const fetchOptions = {
    parser(res: UseCarOfferConfigServerRes): UseCarOfferConfigRes {
        return parseCarOfferConfig(res.offers[0]);
    },
};

export function useCarOfferConfig() {
    return useFetchRequest<{}, UseCarOfferConfigRes, UseCarOfferConfigServerRes>(
        '/api/yandex/offers/create',
        {},
        {
            ...fetchOptions,
            method: 'POST',
            query: {
                offer_builder_type: 'rental_offer_builder',
            },
        },
    );
}
