import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Enter customer details': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter customer details',
        ru: 'Введите данные клиента',
        cs: 'Zadejte údaje o zákazníkovi',
    },
    'Enter customer name': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter customer name',
        ru: 'Введите имя клиента',
        cs: 'Zadejte jméno zákazníka',
    },
    'Enter customer phone number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter customer phone number',
        ru: 'Введите номер телефона клиента',
        cs: 'Zadejte telefonní číslo zákazníka',
    },
    'Enter customer surname': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter customer surname',
        ru: 'Введите фамилию клиента',
        cs: 'Zadejte příjmení zákazníka',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
