import { UserInputData, UserInputState } from 'entities/User/ui/UserInput/UserInput';

import { validate } from 'shared/helpers/validate/validate';
import { validateEmail } from 'shared/helpers/validateEmail/validateEmail';
import { validatePhoneNumber } from 'shared/helpers/validatePhoneNumber/validatePhoneNumber';
import { validateRequired } from 'shared/helpers/validateRequired/validateRequired';
import { FormErrorSchema } from 'shared/types/FormErrorSchema';

import { i18n } from 'features/CarBooking/helpers/validateUserInput/validateUserInput.i18n';

const REQUIRED_ALL = [{ message: i18n('Enter customer details'), code: 'required' }];

export function validateUserInput<S>() {
    return (value: Optional<UserInputData>, store: S): Optional<FormErrorSchema<keyof UserInputState | string>> => {
        if (value) {
            const { first_name, last_name, phone_number, email } = value;

            if (!first_name && !last_name && !phone_number) {
                return REQUIRED_ALL;
            }

            const firstNameError = validateRequired(i18n('Enter customer name'), 'first_name')(first_name);
            const lastNameError = validateRequired(i18n('Enter customer surname'), 'last_name')(last_name);
            const phoneNumberError = validate([
                validateRequired(i18n('Enter customer phone number'), 'phone_number'),
                validatePhoneNumber('phone_number'),
            ])(phone_number, store);
            const emailError = validateEmail('email')(email);

            return [
                ...(firstNameError ? firstNameError : []),
                ...(lastNameError ? lastNameError : []),
                ...(phoneNumberError ? phoneNumberError : []),
                ...(emailError ? emailError : []),
            ];
        }

        return REQUIRED_ALL;
    };
}
