import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add booking': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Add booking',
        ru: 'Добавить бронирование',
        cs: 'Přidat rezervaci',
    },
    Book: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Book',
        ru: 'Забронировать',
        cs: 'Rezervovat',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
