import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { modalScrollState } from 'tests/storybook/helpers/modalScrollState';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    CarAddBookingModal,
    CarAddBookingModalProps,
} from 'features/CarBooking/ui/CarAddBookingModal/CarAddBookingModal';

const storybookMeta = createStorybookMeta<CarAddBookingModalProps>({
    title: 'features/CarBooking/CarAddBookingModal',
    component: CarAddBookingModal,

    hermioneSelector: '[role="dialog"]',

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarAddBookingModalProps>(CarAddBookingModal);

export const normal = Template.bind({});
normal.hermionePlainFn = async function (browser, selector) {
    await modalScrollState(browser, selector);

    await browser.$('[title="Book"]').click();

    return browser.assertView('withError', selector);
};
