import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Car: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car',
        ru: 'Машина',
        cs: 'Vůz',
    },
    Comment: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Comment',
        ru: 'Комментарий',
        cs: 'Komentář',
    },
    Confirmed: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Confirmed',
        ru: 'Подтверждено',
        cs: 'Potvrzeno',
    },
    Currency: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Currency',
        ru: 'Валюта',
        cs: 'Měna',
    },
    Customer: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Customer',
        ru: 'Клиент',
        cs: 'Zákazník',
    },
    'Customer will not see this': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Customer will not see this',
        ru: 'Клиент этого не увидит',
        cs: 'Zákazník toto neuvidí',
    },
    Dates: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Dates',
        ru: 'Даты',
        cs: 'Data',
    },
    Deposit: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Deposit',
        ru: 'Депозит',
        cs: 'Záloha',
    },
    Draft: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Draft',
        ru: 'Не подтверждено',
        cs: 'Návrh',
    },
    'Enter date and time': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter date and time',
        ru: 'Введите дату и время',
        cs: 'Zadejte datum a čas',
    },
    'Enter deposit': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter deposit',
        ru: 'Введите депозит',
        cs: 'Zadejte zálohu',
    },
    'Enter extra mileage charge': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter extra mileage charge',
        ru: 'Введите пробег сверх лимита',
        cs: 'Zadejte příplatek za kilometry navíc',
    },
    'Enter kilometers included': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter kilometers included',
        ru: 'Введите включенный пробег',
        cs: 'Zadejte zahrnuté kilometry',
    },
    'Enter total amount': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Enter total amount',
        ru: 'Введите общую сумму',
        cs: 'Zadejte celkovou částku',
    },
    'Extra mileage charge': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Extra mileage charge',
        ru: 'Пробег сверх лимита',
        cs: 'Příplatek za kilometry navíc',
    },
    Insurance: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Insurance',
        ru: 'Страхование',
        cs: 'Pojištění',
    },
    'Kilometers included': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Kilometers included',
        ru: 'Включенный пробег',
        cs: 'Zahrnuté kilometry',
    },
    'km/day': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'km/day',
        ru: 'км/день',
        cs: 'km/den',
    },
    Options: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Options',
        ru: 'Опции',
        cs: 'Možnosti',
    },
    Paid: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Paid',
        ru: 'Оплачено',
        cs: 'Zaplaceno',
    },
    'per 1 km': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'per 1 km',
        ru: 'за 1 км',
        cs: 'na 1 km',
    },
    'Pick-up and return points': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Pick-up and return points',
        ru: 'Места приема и возврата',
        cs: 'Místa vyzvednutí a vrácení',
    },
    'Pick-up point': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Pick-up point',
        ru: 'Место получения',
        cs: 'Místo vyzvednutí',
    },
    'Return point': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Return point',
        ru: 'Место возврата',
        cs: 'Místo vrácení',
    },
    Select: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Select',
        ru: 'Выбрать',
        cs: 'Vybrat',
    },
    'Select car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Select car',
        ru: 'Выберите автомобиль',
        cs: 'Vyberte vůz',
    },
    'Select pick-up point': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Select pick-up point',
        ru: 'Выберите место получения',
        cs: 'Vyberte místo vyzvednutí',
    },
    'Select return point': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Select return point',
        ru: 'Выберите место возврата',
        cs: 'Vyberte místo vrácení',
    },
    Status: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Status',
        ru: 'Статус',
        cs: 'Stav',
    },
    'Total amount': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Total amount',
        ru: 'Общая сумма',
        cs: 'Celková částka',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
