import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { CarBookingForm, CarBookingFormProps } from 'features/CarBooking/ui/CarBookingForm/CarBookingForm';

import { GeoSuggestSchema } from 'entities/Geo/types/GeoSuggestSchema';

const storybookMeta = createStorybookMeta<CarBookingFormProps>({
    title: 'features/CarBooking/CarBookingForm',
    component: CarBookingForm,

    parameters: { backgrounds: { default: 'white' } },

    args: {
        storybookWidth: '560px',
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarBookingFormProps>(CarBookingForm);

/*eslint-disable @typescript-eslint/no-magic-numbers*/
const DEFAULT_GEO_ITEMS: GeoSuggestSchema[] = [
    // Politických vězňů 912/10
    {
        name: 'Politických Vězňů, 912/10, Praha, Česko',
        lat: 50.0824852,
        lon: 14.42966175,
        geoid: 10511,
    },
    // Prague Airport
    {
        name: 'Prague Václav Havel airport, Praha, Česko',
        lat: 50.10686111,
        lon: 14.26646137,
        geoid: 10512,
    },
];

const OFFER_CONFIG = {
    insurance_types: [
        { title: 'GOLD', id: 'id_gold' },
        { title: 'SILVER', id: 'id_silver' },
        { title: 'BASIC', id: 'id_basic' },
    ],
    offer_options: [
        { title: 'Child seat', id: 'child_seat' },
        { title: 'Snow chains', id: 'snow_chains' },
        { title: 'Roof rack', id: 'roof_rack' },
        { title: 'Entry to eco-zones in Germany', id: 'entry_to_eco_zones_in_germany' },
        { title: 'GPS', id: 'gps' },
    ],
    delivery_locations: DEFAULT_GEO_ITEMS,
    return_locations: DEFAULT_GEO_ITEMS,
    currencies: [
        { title: 'CZK', id: 'id_czk' },
        { title: 'EUR', id: 'id_eur' },
    ],
    limit_km_per_day: 0,
    overrun_cost_per_km: 0,
};

export const normal = Template.bind({});
normal.args = {
    offerConfig: OFFER_CONFIG,
};

export const withoutOverrunOptions = Template.bind({});
withoutOverrunOptions.args = {
    offerConfig: {
        ...OFFER_CONFIG,
        limit_km_per_day: undefined,
        overrun_cost_per_km: undefined,
    },
};

export const customOptions = Template.bind({});
customOptions.args = {
    offerConfig: {
        ...OFFER_CONFIG,
        insurance_types: [
            { title: 'Full protection', id: 'id_full' },
            { title: 'Partial protection', id: 'id_partial' },
            { title: 'Basic protection', id: 'id_basic' },
        ],
        currencies: [
            { title: 'USD', id: 'id_usd' },
            { title: 'EUR', id: 'id_eur' },
        ],
        offer_options: OFFER_CONFIG.offer_options.slice(0, 3),
        limit_km_per_day: 100,
        overrun_cost_per_km: 5,
    },
};
