import * as React from 'react';

import { Checkbox } from 'shared/ui/Checkbox/Checkbox';
import { useForm } from 'shared/hooks/useForm/useForm';
import { CarOfferConfigSchema } from 'entities/Car/types/CarOfferConfigSchema';

export interface CarBookingOfferOptionsProps {
    className?: string;
    values?: Record<string, boolean>;
    offerOptions: Exclude<CarOfferConfigSchema['offer_options'], undefined>;
    disableCompleted?: boolean;
    onChange(state: Record<string, boolean>): void;
}

export const CarBookingOfferOptions: React.FC<CarBookingOfferOptionsProps> = function CarBookingOfferOptions({
    className,
    offerOptions,
    disableCompleted,
    values,
    onChange,
}) {
    const { update, watch } = useForm<Record<string, boolean>>({
        init: values || {},
        validation: {},
        onFormChange: onChange,
    });

    return (
        <div className={className}>
            {offerOptions.map(({ title, id }) => (
                <Checkbox
                    label={title}
                    id={id}
                    checked={Boolean(watch(id))}
                    disabled={disableCompleted}
                    onChange={update(id)}
                    key={id}
                />
            ))}
        </div>
    );
};
