import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Cancel booking?': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Cancel booking?',
        ru: 'Отменить бронирование?',
        cs: 'Zrušit rezervaci?',
    },
    'It can’t be undone': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'It can’t be undone',
        ru: 'Это не может быть отменено',
        cs: 'Tuto akci nelze vrátit zpět',
    },
    No: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'No',
        ru: 'Нет',
        cs: 'Ne',
    },
    Yes: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Yes',
        ru: 'Да',
        cs: 'Ano',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
