import * as React from 'react';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button } from 'shared/ui/Button/Button';
import { DialogContainer, DialogContainerProps } from 'shared/ui/DialogContainer/DialogContainer';

import { i18n } from 'features/CarBooking/ui/CarCancelBookingDialog/CarCancelBookingDialog.i18n';

export interface CarCancelBookingDialogProps extends Pick<DialogContainerProps, 'onClose'> {
    onDialogSubmit(): void;
}

export const CarCancelBookingDialog: React.FC<CarCancelBookingDialogProps> = function CarCancelBookingDialog({
    onDialogSubmit,
    onClose,
}) {
    return (
        <DialogContainer
            title={i18n('Cancel booking?')}
            description={i18n('It can\u2019t be undone')}
            controls={
                <>
                    <Button
                        size={ButtonSize.M}
                        color={ButtonColor.ALARM}
                        label={i18n('Yes')}
                        onClick={onDialogSubmit}
                    />

                    <Button
                        size={ButtonSize.M}
                        color={ButtonColor.SECONDARY}
                        label={i18n('No')}
                        onClick={onClose}
                    />
                </>
            }
        />
    );
};
