import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { modalScrollState } from 'tests/storybook/helpers/modalScrollState';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    CarEditBookingModal,
    CarEditBookingModalProps,
} from 'features/CarBooking/ui/CarEditBookingModal/CarEditBookingModal';

import { UserStatus } from 'entities/User/consts/UserStatus';

const USER = {
    id: '02ee7a4b-8e90-4020-bbbb-8a2723131c49',
    first_name: 'Aleksey',
    last_name: 'Cherenkevich',
    phone_number: '+375336188394',
    email: 'cherenkevich.com@gmail.com',
    status: UserStatus.ACTIVE,
};

const storybookMeta = createStorybookMeta<CarEditBookingModalProps>({
    title: 'features/CarBooking/CarEditBookingModal',
    component: CarEditBookingModal,

    parameters: {
        date: new Date('2022-04-01'),
    },

    hermioneSelector: '[role="dialog"]',

    args: {
        user: USER,
        offerId: '58e9a0ee-2a26-0c58-0029-29888451b7ac',
        tagId: '432f1376-1c06-45b9-9877-2d910032313f',
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarEditBookingModalProps>(CarEditBookingModal);

export const normal = Template.bind({});
normal.hermionePlainFn = modalScrollState;

export const deletedUser = Template.bind({});
deletedUser.args = {
    user: {
        ...USER,
        status: UserStatus.DELETED,
    },
};
deletedUser.hermionePlainFn = modalScrollState;

export const inProgressStatus = Template.bind({});
inProgressStatus.args = { offerId: '58e9a0ee-2a26-0c58-0029-29888451b8ac' };
inProgressStatus.parameters = { date: new Date('2022-04-20') };
inProgressStatus.hermionePlainFn = modalScrollState;

export const completedStatus = Template.bind({});
completedStatus.args = { offerId: '58e9a0ee-2a26-0c58-0029-29888451b9ac' };
completedStatus.parameters = { date: new Date('2022-04-30') };
completedStatus.hermionePlainFn = modalScrollState;

export const outdatedStatus = Template.bind({});
outdatedStatus.parameters = { date: new Date('2022-04-30') };
outdatedStatus.hermionePlainFn = modalScrollState;
