import * as React from 'react';
import cn from 'classnames/bind';

import { CarSignalqStatusType } from 'entities/Car/consts/CarSignalqStatusType';
import { getCarSignalqStatus } from 'entities/Car/helpers/getCarSignalqStatus/getCarSignalqStatus';

import { TextWithDotSize } from 'shared/consts/TextWithDotSize';
import { TextWithDot } from 'shared/ui/TextWithDot/TextWithDot';

import styles from 'features/CarCameraStatus/ui/CarCameraStatus/CarCameraStatus.css';

const cx = cn.bind(styles);

export interface CarStatusProps {
    className?: string;
    size?: TextWithDotSize;

    customLabel?: string;
    status: CarSignalqStatusType;
    shortLabel?: boolean;
}

export const CarCameraStatus: React.FC<CarStatusProps> = function CarCameraStatus({
    className,
    status,
    size,
    customLabel,
    shortLabel,
}) {
    return (
        <TextWithDot
            size={size}
            className={cx({}, [status, className])}
        >
            {customLabel ? customLabel : getCarSignalqStatus(status, shortLabel)}
        </TextWithDot>
    );
};
