import * as React from 'react';
import cn from 'classnames/bind';

import { CarStatusType } from 'entities/Car/consts/CarStatusType';
import { getCarStatus } from 'entities/Car/helpers/getCarStatus/getCarStatus';

import { TextWithDotSize } from 'shared/consts/TextWithDotSize';
import { TextWithDot } from 'shared/ui/TextWithDot/TextWithDot';

import styles from 'features/CarStatus/ui/CarStatus/CarStatus.css';

const cx = cn.bind(styles);

export interface CarStatusProps {
    className?: string;
    size?: TextWithDotSize;

    customLabel?: string;
    status: CarStatusType;
}

export const CarStatus: React.FC<CarStatusProps> = function CarStatus({ className, status, size, customLabel }) {
    return (
        <TextWithDot
            size={size}
            className={cx({}, [status, className])}
        >
            {customLabel ? customLabel : getCarStatus(status)}
        </TextWithDot>
    );
};
