import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Damages: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Damages',
        ru: 'Повреждения',
        cs: 'Poškození',
    },
    Overview: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Overview',
        ru: 'Обзор',
        cs: 'Přehled',
    },
    Rides: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Rides',
        ru: 'Поездки',
        cs: 'Jízdy',
    },
    Signals: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signals',
        ru: 'Сигналы',
        cs: 'Signály',
    },
    Telematics: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Telematics',
        ru: 'Телематика',
        cs: 'Telematika',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
