import * as React from 'react';

import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    CarCardHeaderTabs,
    CarCardHeaderTabsProps,
} from 'features/CarCardHeaderTabs/ui/CarCardHeaderTabs/CarCardHeaderTabs';

import { useCar } from 'entities/Car/api/useCar/useCar';

const storybookMeta = createStorybookMeta<CarCardHeaderTabsProps>({
    title: 'features/CarCardHeaderTabs/CarCardHeaderTabs',
    component: CarCardHeaderTabs,

    decorators: [withStorybookRouter()],

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarCardHeaderTabsProps & { id: string }>(({ id, ...otherProps }) => {
    const resource = useCar({ carId: id });

    return (
        <CarCardHeaderTabs
            {...otherProps}
            resource={resource}
        />
    );
});

export const normal = Template.bind({});
normal.args = {
    id: '008fe5a4-56c4-975c-7abc-20f37d523cc7',
};

export const withSession = Template.bind({});
withSession.parameters = { flags: { showSessions: true } };
withSession.args = {
    id: '008fe5a4-56c4-975c-7abc-20f37d523cc7',
};

export const withTelematics = Template.bind({});
withTelematics.parameters = { flags: { showTelematics: true } };
withTelematics.args = {
    id: '000c7f42-fa23-8c5c-216f-d1faeb1743c5',
};

export const withDamages = Template.bind({});
withDamages.parameters = { flags: { car_damage: true } };
withDamages.args = {
    id: '008fe5a4-56c4-975c-7abc-20f37d523cc7',
};

export const full = Template.bind({});
full.parameters = { flags: { showSessions: true, showTelematics: true, car_damage: true } };
full.args = {
    id: '000c7f42-fa23-8c5c-216f-d1faeb1743c5',
};
