import { CarCreateFormSchema } from 'features/CarCreate/types/CarCreateFormSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';

export interface PostCarCreatePayloadItem {
    vin: string;
    number?: string;
    registry_model: string;
    registry_manufacturer: string;
    city?: string;
    registration_id?: string;
    color?: string;
}

interface PostCarCreatePayload {
    cars: PostCarCreatePayloadItem[];
}

export function postCarCreate(data: CarCreateFormSchema | PostCarCreatePayloadItem[]) {
    let payload: PostCarCreatePayload;

    if (Array.isArray(data)) {
        payload = {
            cars: data,
        };
    } else {
        payload = {
            cars: [
                {
                    vin: data.vin,
                    number: data.number,
                    registry_model: data.model.registry_model,
                    registry_manufacturer: data.model.registry_manufacturer,
                },
            ],
        };
    }

    return fetchRequest<PostCarCreatePayload, unknown>('/api/leasing/car/batch-upload', payload, {
        method: 'POST',
    });
}
