import { PostCarCreatePayloadItem } from 'features/CarCreate/api/postCarCreate/postCarCreate';
import { CAR_XLSX_MODEL, HEADER_ROWS_COUNT } from 'features/CarCreate/consts/constants';

export function generateCarsPayload(carsData: string[][]) {
    const cars: PostCarCreatePayloadItem[] = [];

    for (let i = HEADER_ROWS_COUNT; i < carsData.length; i++) {
        const carItem = carsData[i];

        const isCarValid =
            carItem[CAR_XLSX_MODEL.VIN_INDEX] &&
            carItem[CAR_XLSX_MODEL.MODEL_INDEX] &&
            carItem[CAR_XLSX_MODEL.MANUFACTURER_INDEX];

        if (isCarValid) {
            cars.push({
                vin: carItem[CAR_XLSX_MODEL.VIN_INDEX],
                registry_model: carItem[CAR_XLSX_MODEL.MODEL_INDEX],
                registry_manufacturer: carItem[CAR_XLSX_MODEL.MANUFACTURER_INDEX],
                city: carItem[CAR_XLSX_MODEL.CITY_INDEX],
                number: carItem[CAR_XLSX_MODEL.NUMBER_INDEX],
                registration_id: carItem[CAR_XLSX_MODEL.REGISTRATION_INDEX],
                color: carItem[CAR_XLSX_MODEL.COLOR_INDEX],
            });
        }
    }

    return cars;
}
