import XLSX from 'xlsx';

export function processXLSX(file: File): Promise<string[][]> {
    const reader = new FileReader();

    reader.readAsBinaryString(file);

    return new Promise((resolve, reject) => {
        reader.onload = () => {
            const binaryData = reader.result;

            try {
                const workbook = XLSX.read(binaryData, {
                    type: 'binary',
                });

                const firstSheetName = workbook.SheetNames[0];
                const firstSheetData = workbook.Sheets[firstSheetName];

                resolve(XLSX.utils.sheet_to_json(firstSheetData, { header: 1 }));
            } catch (error) {
                reject(error);
            }
        };
    });
}
