import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Add cars': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Add cars',
        ru: 'Добавить машины',
        cs: '',
    },
    'Add cars via XLSX-file': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Add cars via XLSX-file',
        ru: 'Добавить машины через XLSX-файл',
        cs: '',
    },
    'Back to manual adding': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Back to manual adding',
        ru: 'Вернуться к ручному добавлению',
        cs: '',
    },
    'Browse XLSX-file': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Browse XLSX-file',
        ru: 'Загрузить XLSX-файл',
        cs: '',
    },
    'Car details': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car details',
        ru: 'Подробная информация',
        cs: 'Podrobnosti o vozu',
    },
    'download the template': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'download the template',
        ru: 'скачайте шаблон',
        cs: '',
    },
    'Failed to parse data': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Failed to parse data',
        ru: 'Не удалось проанализировать данные',
        cs: '',
    },
    'Incorrect file type': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Incorrect file type',
        ru: 'Неправильный тип файла',
        cs: '',
    },
    'Something went wrong': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Something went wrong',
        ru: 'Что-то пошло не так',
        cs: 'Něco se pokazilo',
    },
    'To upload several cars at once {link} and fill it out with your data. Then upload your XLSX-file using this form':
        {
            _meta: {
                status: {
                    en: 'REQUIRES_TRANSLATION',
                    ru: 'REQUIRES_TRANSLATION',
                    cs: 'REQUIRES_TRANSLATION',
                },
            },
            en: 'To upload several cars at once {link} and fill it out with your data. Then upload your XLSX-file using this form',
            ru: 'Чтобы загрузить сразу несколько автомобилей, {link} и заполните его данными. Затем загрузите свой XLSX-файл, используя эту форму',
            cs: '',
        },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
