import * as React from 'react';

import { CarCreateModal } from 'features/CarCreate/ui/CarCreateModal/CarCreateModal';

import { ButtonColor } from 'shared/consts/ButtonColor';
import { ButtonSize } from 'shared/consts/ButtonSize';
import { Button } from 'shared/ui/Button/Button';

import { i18n } from 'features/CarCreate/ui/CarCreate/CarCreate.i18n';

import PlusIcon from 'shared/ui/Icons/images/plus-outline-16.inline.svg';

export interface CarCreateProps {
    className?: string;
}

export const CarCreate: React.FC<CarCreateProps> = function CarCreate({ className }) {
    const [hasAddCarForm, setAddCarForm] = React.useState(false);

    const onAddCarFormShow = React.useCallback(() => {
        setAddCarForm(true);
    }, [setAddCarForm]);

    const onAddCarFormClose = React.useCallback(() => {
        setAddCarForm(false);
    }, [setAddCarForm]);

    return (
        <>
            <Button
                className={className}
                color={ButtonColor.PRIMARY}
                size={ButtonSize.M}
                icon={PlusIcon}
                label={i18n('Add car')}
                onClick={onAddCarFormShow}
            />

            {hasAddCarForm && <CarCreateModal onClose={onAddCarFormClose} />}
        </>
    );
};
