import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Car details': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car details',
        ru: 'Подробная информация',
        cs: 'Podrobnosti o vozu',
    },
    'Car ID': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car ID',
        ru: 'ID машины',
        cs: 'ID vozu',
    },
    'License plate number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'License plate number',
        ru: 'Регистрационный номер',
        cs: 'Číslo registrační značky',
    },
    Model: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Model',
        ru: 'Модель',
        cs: 'Model',
    },
    VIN: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'VIN',
        ru: 'VIN',
        cs: 'VIN',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
