import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '{count} known damage': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: {
            one: '{count} known damage',
            other: '{count} known damages',
        },
        ru: {
            one: '{count} известное повреждение',
            few: '{count} известных повреждения',
            many: '{count} известных повреждений',
        },
        cs: {
            one: '{count} známé poškození',
            few: '{count} známých poškození',
            other: '',
        },
    },
    'There are no known damages for this car': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'There are no known damages for this car',
        ru: 'О повреждениях этого автомобиля ничего не известно',
        cs: 'Neexistují žádné známé škody na tomto autě',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
