import * as React from 'react';

import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { CarDamages, CarDamagesProps } from 'features/CarDamages/ui/CarDamages/CarDamages';

import { useCarDamages } from 'entities/Car/api/useCarDamage/useCarDamages';

import 'features/CarDamages/ui/CarDamages/CarDamages.story.global.css';

const storybookMeta = createStorybookMeta<CarDamagesProps>({
    title: 'features/CarDamages/CarDamages',
    component: CarDamages,

    args: {
        storybookClassName: 'sb-car-damages',
        storybookWidth: '968px',
    },

    decorators: [withStorybookRouter()],

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarDamagesProps & { id: string }>(({ id, ...otherProps }) => {
    const carDamagesResource = useCarDamages(id);

    return (
        <CarDamages
            {...otherProps}
            resource={carDamagesResource}
        />
    );
});

export const normal = Template.bind({});
normal.args = { id: '694ea8ae-37c1-4912-8503-a31f12fa25e7' };

export const empty = Template.bind({});
empty.args = {
    storybookHeight: '768px',

    id: '38ce6b44-6ee6-d397-42c5-ec0b495d2af6',
};
