import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Registered on {date}': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Registered on {date}',
        ru: 'Добавлено {date}',
        cs: 'Zaregistrováno dne {date}',
    },
    'View ride': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'View ride',
        ru: 'Посмотреть поездку',
        cs: 'Zobrazit jízdu',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
