import { buildDummyImageInline } from 'tests/storybook/helpers/buildDummyImageInline';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { hoverState } from 'tests/storybook/helpers/hoverState';

import { CarDamagesItem, CarDamagesItemProps } from 'features/CarDamages/ui/CarDamagesItem/CarDamagesItem';

const storybookMeta = createStorybookMeta<CarDamagesItemProps>({
    title: 'features/CarDamages/CarDamagesItem',
    component: CarDamagesItem,

    parameters: {
        backgrounds: { default: 'white' },
    },

    args: {
        storybookWidth: '300px',

        src: buildDummyImageInline({}),
        title: 'Front bumper (right)',
        createdAt: new Date('2022-01-01T09:23:00'),
        sessionId: '123',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarDamagesItemProps>(CarDamagesItem);

export const normal = Template.bind({});
normal.hermioneFn = hoverState;

export const long = Template.bind({});
long.args = { title: 'car.damage.element.bumper_front_bottom_right.title' };
long.hermioneFn = hoverState;

export const withoutData = Template.bind({});
withoutData.args = { createdAt: undefined, sessionId: undefined };
withoutData.hermioneFn = hoverState;
