import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Go to the ride': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Go to the ride',
        ru: 'Перейти к поездке',
        cs: 'Přejít na jízdu',
    },
    'Registered on {date}': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Registered on {date}',
        ru: 'Добавлено {date}',
        cs: 'Zaregistrováno dne {date}',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
