import { buildDummyImageInline } from 'tests/storybook/helpers/buildDummyImageInline';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import { CarDamagesPreview, CarDamagesPreviewProps } from 'features/CarDamages/ui/CarDamagesPreview/CarDamagesPreview';

const storybookMeta = createStorybookMeta<CarDamagesPreviewProps>({
    title: 'features/CarDamages/CarDamagesPreview',
    component: CarDamagesPreview,

    hermioneSelector: '[role="dialog"]',

    args: {
        src: buildDummyImageInline({ width: 1280, height: 720 }),
        title: 'Front bumper (right)',
        createdAt: new Date('2022-01-01T09:23:00'),
        sessionId: '123',
    },
});

export default storybookMeta;

const Template = createStorybookTemplate<CarDamagesPreviewProps>(CarDamagesPreview);

export const normal = Template.bind({});

export const long = Template.bind({});
long.args = {
    src: buildDummyImageInline({ width: 720, height: 1280 }),
    title: 'car.damage.element.bumper_front_bottom_right.title',
};

export const withoutData = Template.bind({});
withoutData.args = { createdAt: undefined, sessionId: undefined };
