import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';
import { CacheRequestContext } from 'shared/hooks/useCacheRequestContext/useCacheRequestContext';

export interface FetchCarTelematicsPasswordResult {
    method: string;
    password: string;
    imei: string;
}

export interface FetchCarTelematicsPasswordData {
    carId: string;
    cache: CacheRequestContext;
}

export interface FetchCarTelematicsPasswordPayload {
    car_id: string;
}

export function fetchCarTelematicsPassword({ carId, cache }: FetchCarTelematicsPasswordData) {
    return fetchRequest<FetchCarTelematicsPasswordPayload, FetchCarTelematicsPasswordResult>(
        '/api/leasing/car/telematics/password',
        {
            car_id: carId,
        },
        {
            cache,
        },
    );
}
