import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';

export interface PostCarBeaconSearchData {
    carId: string;
    state: boolean;
    imei: string;
}

export interface PostCarBeaconSearchPayload {
    imeis: string[];
}

export function postCarBeaconSearch({ carId, state, imei }: PostCarBeaconSearchData) {
    return fetchRequest<PostCarBeaconSearchPayload, unknown>(
        '/api/leasing/car/beacon/search',
        {
            imeis: [imei],
        },
        {
            method: 'POST',
            query: {
                car_id: carId,
                search_state: state ? '1' : '0',
            },
        },
    );
}
