import { ONE_SECOND } from 'constants/constants';

import { CarCameraStatusHistoryIntervalSchema } from 'entities/Car/types/CarCameraStatusHistoryIntervalSchema';

import { useFetch, UseFetchResource } from 'shared/hooks/useFetch/useFetch';

export interface UseCarCameraStatusHistoryIntervalsListOptions {
    carId: string;
    since: Date;
    until: Date;
}

export interface UseCarCameraStatusHistoryIntervalsListReq {
    car_id: string;
    period?: {
        from: number;
        to: number;
    };
    statuses_intervals_limit: number;
}

export interface UseCarCameraStatusHistoryIntervalsListServerRes {
    intervals: CarCameraStatusHistoryIntervalSchema[];
}

export type UseCarCameraStatusHistoryIntervalsListRes = Array<{
    status: string;
    start_at: Date;
    end_at: Date;
}>;

export type UseCarCameraStatusHistoryIntervalsListResource =
    UseFetchResource<UseCarCameraStatusHistoryIntervalsListRes>;

const LIMIT = 1000;

function parser(res: UseCarCameraStatusHistoryIntervalsListServerRes): UseCarCameraStatusHistoryIntervalsListRes {
    return res.intervals.map(({ status, start_at, end_at }) => {
        return {
            status,
            start_at: new Date(start_at * ONE_SECOND),
            end_at: new Date(end_at * ONE_SECOND),
        };
    });
}

export function useCarCameraStatusHistoryIntervalsList(
    { carId, since, until }: UseCarCameraStatusHistoryIntervalsListOptions,
    disabled?: boolean,
) {
    return useFetch<
        UseCarCameraStatusHistoryIntervalsListReq,
        UseCarCameraStatusHistoryIntervalsListRes,
        UseCarCameraStatusHistoryIntervalsListServerRes
    >(
        '/api/leasing/signalq/status-history/intervals/list',
        {
            car_id: carId,
            period: {
                from: Math.round(since.getTime() / ONE_SECOND),
                to: Math.round(until.getTime() / ONE_SECOND),
            },
            statuses_intervals_limit: LIMIT,
        },
        {
            method: 'POST',
            parser,
        },
        disabled,
    );
}
