import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'In search mode the beacon will transmit data every 20 minutes instead of 2 times a day': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'In search mode the beacon will transmit data every 20 minutes instead of 2 times a day',
        ru: 'В режиме "Слежения" маяк будет отправлять данные каждые 20 минут, вместо 2 раз в день',
        cs: 'V režimu "Vyhledávání" bude maják posílat signal každých 20 minut namísto 2krát denně',
    },
    'Search mode was disabled': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Search mode was disabled',
        ru: 'Режим "Слежения" выключен',
        cs: 'Režim vyhledávání byl deaktivován',
    },
    'Search mode was enabled': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Search mode was enabled',
        ru: 'Режим "Слежения" включён',
        cs: 'Režim vyhledávání byl aktivován',
    },
    'Search mode will start working soon': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Search mode will start working soon',
        ru: 'Режим "Слежения" скоро будет включен',
        cs: 'Režim vyhledávání se brzy spustí',
    },
    'Search mode will stop working soon': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Search mode will stop working soon',
        ru: 'Режим "Слежения" скоро будет выключен',
        cs: 'Režim vyhledávání bude brzy vypnut',
    },
    'Turn off': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Turn off',
        ru: 'Выключить',
        cs: 'Vypnout',
    },
    'Turn on': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'APPROVED',
                cs: 'APPROVED',
            },
        },
        en: 'Turn on',
        ru: 'Включить',
        cs: 'Zapnout',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
