import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    '24h camera history': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'TRANSLATED',
                cs: 'APPROVED',
            },
        },
        en: '24h camera history',
        ru: 'История за 24 ч',
        cs: 'Historie kamery za 24 h',
    },
    'Current speed': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Current speed',
        ru: 'Текущая скорость',
        cs: 'Aktuální rychlost',
    },
    'Serial number': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Serial number',
        ru: 'Серийный номер',
        cs: 'Sériové číslo',
    },
    Status: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Status',
        ru: 'Статус',
        cs: 'Stav',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
