import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'loading error': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'loading error',
        ru: 'ошибка загрузки',
        cs: 'chyba načítání',
    },
    'loading...': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'loading...',
        ru: 'загрузка...',
        cs: 'načítání...',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
