import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import {
    CarCameraHardwareTimeline,
    CarCameraHardwareTimelineProps,
} from 'features/CarHardware/ui/CarCameraHardwareTimeline/CarCameraHardwareTimeline';

const storybookMeta = createStorybookMeta<CarCameraHardwareTimelineProps>({
    title: 'features/CarHardware/CarCameraHardwareTimeline',
    component: CarCameraHardwareTimeline,

    args: {
        storybookWidth: '600px',
        storybookStyles: { background: '#fff', padding: '10px' },
    },

    parameters: {
        date: new Date('2022-05-26T15:00:00'),
    },

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarCameraHardwareTimelineProps>(CarCameraHardwareTimeline);

export const facedAway = Template.bind({});
facedAway.args = {
    carId: '0117e77f-9b43-5009-53c6-b931728bb50d',
};

export const offline = Template.bind({});
offline.args = {
    carId: '064e889b-0883-4288-0cba-1b854f685e08',
};

export const loading = Template.bind({});
loading.args = {
    carId: '0854679b-ced8-f01c-f73a-1f675104ae8f',
};

export const error = Template.bind({});
error.args = {
    carId: '1',
};
