import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    Beacon: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Beacon',
        ru: 'Маяк',
        cs: 'Maják',
    },
    Camera: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Camera',
        ru: 'Камера',
        cs: 'Kamera',
    },
    Car: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Car',
        ru: 'Машина',
        cs: 'Vůz',
    },
    'Download config': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Download config',
        ru: 'Скачать конфигурацию',
        cs: '',
    },
    Edit: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Edit',
        ru: 'Редактировать',
        cs: 'Upravit',
    },
    'Failed to download config': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Failed to download config',
        ru: 'Не удалось скачать конфигурацию',
        cs: '',
    },
    'Failed to upload config.': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Failed to upload config.',
        ru: 'Не удалось загрузить конфигурацию',
        cs: '',
    },
    Telematics: {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Telematics',
        ru: 'Телематика',
        cs: 'Telematika',
    },
    'The new config was successfully applied': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'The new config was successfully applied',
        ru: 'Новая конфигурация успешно применена',
        cs: '',
    },
    'Try again': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Try again',
        ru: 'Попробовать снова',
        cs: 'Zkuste to znovu',
    },
    'Upload another config': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Upload another config',
        ru: 'Загрузить другую конфигурацию',
        cs: '',
    },
    'Uploading new config...': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'REQUIRES_TRANSLATION',
            },
        },
        en: 'Uploading new config...',
        ru: 'Загрузка новой конфигурации...',
        cs: '',
    },
    'View beacon details': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'View beacon details',
        ru: 'Показать детали маяка',
        cs: 'Zobrazit podrobnosti o majáku',
    },
    'View telematics details': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'View telematics details',
        ru: 'Показать детали телематики',
        cs: 'Zobrazit podrobnosti telematiky',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
